﻿<%@ Page Language="C#" AutoEventWireup="True" CodeBehind="ErrorCorrection.aspx.cs" Inherits="Kesion.NET.WebExam.Exam.ErrorCorrection" %>
<!DOCTYPE html>
<html>
<head runat="server">
    <title></title>
    <link rel="stylesheet" href="images/css.css" type="text/css"/>
    <script src="../ks_inc/jquery.js"></script>
    <script src="../ks_inc/Kesion.Common.js"></script>
	<% Kesion.APPCode.EditorAPI.EchoHead(); %>
    <style>
    /*纠错样式*/
	*{ margin:0; padding:0;}
	.errorTable{ border:1px solid #e2e2e2;margin-top: 30px;}
	.errorTable tr td{ padding:10px; line-height:25px; font-size:14px;}
	.errorTable tr.tableTitle td{ background:#f8f8f8;font-size: 16px;}
	.errorTable tr.tableTitle span{ font-weight:bold; display:block; text-align:center;}
	.errorTable td p{ color:#888;}
	#content{ display:block; border:0;border-top:1px solid #e2e2e2;border-bottom:1px solid #e2e2e2; padding:10px; width:100%; min-height:150px; box-sizing:border-box;resize:none;}
	#content:focus{outline:none;}
	.errorTable .tableCenter td{ padding:0;}
	.tableTips{ padding:10px;}
	.tableBottom td{ background:#f8f8f8;}
	.tableBottom .button{ height:35px;border:0; background:#0288d1; color:#fff; vertical-align:middle; border-radius:5px; padding:0 15px; margin:0 5px;    letter-spacing: 1px;}
	.tableBottom .button:focus{outline:none;}
    </style>
</head>
<body>
   	<script>
       function check() {
           if (editor.hasContents()==false) {
               KesionJS.Alert("请输入纠错内容！", "editor.focus();");
             return false;
           }
           return true;
       }
   	</script>
    <form id="form1" runat="server">
        <table width="100%" height="100%" cellpadding="0" class="errorTable" cellspacing="0">
            <tr class="tableTitle">
                <td colspan="2" align="left">
                    <span>试卷名称：<%=dr["Title"].ToString()%></span>
                </td>
            </tr>
            <tr class="tableCenter">
                <td colspan="2" align="left">
                   <div class="tableTips">
                       <p>如果您发现本试卷有错误，请反馈给我们，收到后我们将及时更正！</p>
                       <p>提交时请说明具体的题号。</p>
                   </div>
                   <textarea name="content" id="content"></textarea>
                   <% Kesion.APPCode.EditorAPI.EchoEditor("editor", "content", "Basic", 0, false, true, true, false); %>
                </td>
            </tr>
            <tr class="tableBottom">
                <td colspan="2" align="center"> 
                   <asp:Button ID="Button1" runat="server" Text="提交错误报告" OnClientClick="return(check());" CssClass="button" 
                          onclick="Button1_Click" />
                   <input type="button" value="取消关闭" onClick="top.box.close()" class="button"/>
                </td>
            </tr>  
        </table>
    </form>
</body>
</html>
